<?php
/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 *                                visit.PHP!
 *       Copyright (c)2002 by Christian Blichmann. All Rights reserved.
 *
 ******************************************************************************
 * Product Name:        visit.PHP!
 * Product Version:     0.1 (alpha)
 * Procuct Description: visit.PHP! is a sophisticated MySQL-based visit-counter
 *                      for web sites.
 * Original Filename:   visitphp.php
 * File Version:        0.1 (alpha)
 * File Description:    visit.PHP! core component
 ******************************************************************************
 * Browser(s):          [all]
 * Scripting engine(s): PHP 4.0.4 (Zend) or higher
 * Web server(s):       [all PHP supported]
 * Server APIs:         [all PHP supported, especially ISAPI]
 * Database(s):         MySQL 3.x or higher
 * Bugs & Limitations:
 *   - Automatic database creation untested...
 *   - Not yet thoroughfully tested, but basic-counter should work
 *   - ctr_get_online_users doesn't yet work correctly
 * Notes:
 *   - Should use microtime() instead of time() (evaluating this)
 *   - Needs file visitphp.mysql for database creation
 ******************************************************************************
 * DISCLAIMER OF WARRANTY: This Script may contain pre-release code which may
 * be modified substantially or obtain additional features before general
 * availability. You should exercise caution in the use of the script. The
 * Alpha Script may not be at the level of performance or compatibility of
 * generally available products, and should not be used for productive
 * purposes. In addition, I do not provide any maintenance, upgrades or other
 * support, except through separate agreement.
 *
 * THIS SCRIPT IS PROVIDED "AS IS" WITHOUT WARRANTY OR CONDITION OF ANY KIND
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTY OR CONDITION OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE ENTIRE RISK ARISING OUT OF THE USE OR PERFORMANCE OF THE
 * PROGRAMS AND DOCUMENTATION REMAINS WITH YOU. IN NO EVENT WILL CHRISTIAN
 * BLICHMANN BE LIABLE FOR ANY DIRECT OR INDIRECT DAMAGE INCLUDING BUT NOT
 * LIMITED TO LOST PROFITS, LOST SAVINGS, DIRECT, INDIRECT OR OTHER ECONOMIC
 * CONSEQUENTIAL DAMAGES, EVEN IF CHRISTIAN BLICHMANN HAS BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES. IN ADDITION CHRISTIAN BLICHMANN WILL NOT
 * BE LIABLE FOR ANY DAMAGES CLAIMED BY YOU BASED ON ANY THIRD PARTY CLAIM.
 ******************************************************************************/

// Settings section, change these accordingly
define("CTR_DEBUG", false);                        // Enable diagnostic messages

define("CTR_MYSQL_HOST", "localhost"); // Server upon which the database resides
define("CTR_MYSQL_USER", "user");                                    // Username
define("CTR_MYSQL_PASSWORD", "password");                            // Password
define("CTR_MYSQL_DATABASE", "database");  // Database to be used - should exist
define("CTR_MYSQL_AUTOCLOSE", false);       // Automatically close db-connection

define("CTR_BLOCKTIME",  1800);     // Ignore visits within specified time (sec)
define("CTR_ONLINETIME",  120);     // Seconds to stay to count user as "online"
define("CTR_OFFSET",        0);          // Allows you to start with "10000" ;-)
// End settings

// Counter functions
$ctr_mysqldb = false;
$ctr_page_id = 0;

function ctr_create_db() {
	global $ctr_mysqldb;
	
	$f = fopen("visitphp.mysql", "r");
	
	$s = "";
	while (!feof($f) && $r)
		$s += fgets($f) + "\n";

	fclose($f);

	$r = false;
	if ($ctr_mysqldb = @mysql_connect(CTR_MYSQL_HOST, CTR_MYSQL_USER,
		CTR_MYSQL_PASSWORD)) {
		if ($r = @mysql_create_db(CTR_MYSQL_DATABASE))
			$r = @mysql_query($s);
	}

	return $ctr_mysqldb && $r;
}

function ctr_connect($allow_create = false) {
	global $ctr_mysqldb;
	
	if (!($ctr_mysqldb = @mysql_connect(
		CTR_MYSQL_HOST, CTR_MYSQL_USER, CTR_MYSQL_PASSWORD
	))) {
		if (!@mysql_select_db(CTR_MYSQL_DATABASE) && $allow_create) {
			if (!ctr_create_db())
				die(CTR_DEBUG ? "Error: Database creation failed.<br>\n" : "");
		} else
			die(CTR_DEBUG ? "Error: Connection to \"" . CTR_MYSQL_USER . "@" .
				CTR_MYSQL_HOST . "\" failed.<br>\n" : "");
	}

	return $ctr_mysqldb;
}

function ctr_close() {
	global $ctr_mysqldb;
	
    if ($ctr_mysqldb) @mysql_close($ctr_mysqldb);
}

function ctr_add_visit() {
	global $ctr_mysqldb, $ctr_page_id;
	
	if ($ctr_mysqldb || ctr_connect()) {
		// Try to select database, issue error msg on failure
	    if (!@mysql_select_db(CTR_MYSQL_DATABASE))
			die(CTR_DEBUG ?	"Error: \"" . CTR_MYSQL_DATABASE .
				"\" - no such database.<br>\n" : "");
		else {
			// Use this visit-time for further calculations
			$time = time();
			
			// Get folder_path, folder_name and file_name
			$slf =         dirname($GLOBALS["PHP_SELF"]);
			$tmp =         strrpos($slf, "/");
			
			$folder_path = substr($slf, 0, $tmp);
			$folder_name = substr(strrchr($slf, "/"), 1);
			$file_name =   basename($GLOBALS["PHP_SELF"]);
			
			// Get this folder's id
			$r = @mysql_query("SELECT id FROM folder WHERE name = \"$folder_name\" AND path = \"$folder_path\"");
			
			if (@mysql_num_rows($r) > 0)                         // Folder found
				$folder_id = mysql_result($r, 0);
			else {                     // Folder not found, insert into database
				@mysql_query("INSERT INTO folder VALUES (0, \"$folder_path\", \"$folder_name\")");
				
				$folder_id = @mysql_insert_id();
			}
			
			// Determine this page's id
			$r = @mysql_query("SELECT id FROM page WHERE folder_id = $folder_id AND filename = \"$file_name\"");
			
			if (@mysql_num_rows($r) > 0)                           // Page found
				$ctr_page_id = mysql_result($r, 0);
			else {                       // Page not found, insert into database
				@mysql_query("INSERT INTO page VALUES (0, $folder_id, \"$file_name\", \"\", \"\", \"\", \"\", 0, 5.5, 0)");
				
				$ctr_page_id = @mysql_insert_id();
			}
			
			// Get user's IP and user agent
			$ip = ip2long(($tmp = @$_SERVER["HTTP_X_FORWARD_FOR"]) ? $tmp : $_SERVER["REMOTE_ADDR"]);
			$useragent = $_SERVER["HTTP_USER_AGENT"];
			
			// Check if visit already counted
			$id = 0;
			$counted = false;
			$r = @mysql_query("SELECT visitor.id, visitor.ip, visitor.useragent, visits.timestamp FROM visitor, visits WHERE visitor.id = visits.visitor_id ORDER BY visitor.id DESC");
			
			if (@mysql_num_rows($r) > 0) {                         // Hits found
				while ($row = @mysql_fetch_object($r))
					if (($ip == $row->ip) && ($useragent == $row->useragent) && (
						($time - $row->timestamp) <= CTR_BLOCKTIME)) {
						$counted = true;
						$id = $row->id;
						break;
					}
			}
			
			if (!$counted) {
			    // Insert visit into database
				@mysql_query("INSERT INTO visitor VALUES (0, $ip, \"$useragent\")");
				@mysql_query("INSERT INTO visits VALUES (LAST_INSERT_ID(), $ctr_page_id, $time)");
			} else
			    // Update entry to reset the blocking time (if user reloaded the page)
				@mysql_query("UPDATE visits SET timestamp=$time WHERE visitor_id=$id");
		}
		if (CTR_MYSQL_AUTOCLOSE) @mysql_close($mysqldb);
    }
}

function ctr_get_visits($page = 0, $within = 0) {
	global $ctr_mysqldb;
	
	if ($ctr_mysqldb || ctr_connect()) {
		// Try to select database, issue error msg on failure
	    if (!@mysql_select_db(CTR_MYSQL_DATABASE)) {
			echo CTR_MYSQL_DATABASE . " - no such database";
		} else {
			$time = time();

			$r = @mysql_query(
				  "SELECT page_id, timestamp FROM visits"
				. ($page + $within > 0 ? " WHERE " : "")
				. ($page > 0 ? "(page_id = $page) AND " : "")
				. ($within > 0 ? "($time - timestamp <= $within)" : "")
			);
			
			return @mysql_num_rows($r) + CTR_OFFSET;
		}
		if (CTR_MYSQL_AUTOCLOSE) @mysql_close($mysqldb);
    }
}

function ctr_get_online_users($page = 0) {
	$r = ctr_get_visits($page, CTR_ONLINETIME);
	
	if ($r == 0) $r = 1;          // Prevent "0 users online" (would be paradox)
	
	return $r;
}
?>